Attribute VB_Name = "ForceFeedback"
Dim dx As DirectX8
Dim di As DirectInput8

Public diDev() As DirectInputDevice8
Dim diEnumDev As DirectInputEnumDevices8
Dim diDevInst As DirectInputDeviceInstance8
Dim diDevObjEnum As DirectInputEnumDeviceObjects
Dim devobj As DirectInputDeviceObjectInstance
 
Dim devcaps As DIDEVCAPS
Dim ForceX As Boolean, ForceY As Boolean
Dim FoundForce As Boolean
Dim efftype As Long
Dim strObjGuid As String
Dim di_effect() As DirectInputEffect
Dim EffectInfo As DIEFFECT
Public FirstFF As Boolean

Public Sub Rumble_State(deviceid As Integer, FFState As Integer, Sduration, Optional xVal = "", Optional YVal = "", Optional Strength = "")
On Error Resume Next
If FirstFF = True Then
    Init_FF
    FirstFF = False
End If

If FFState = 1 Then
    
    If Sduration <> -1 Then
        With EffectInfo
            
            .lDuration = Sduration * 1000 'Infinite
            
            
        End With
        
    Else
        With EffectInfo
        .lDuration = -1
        End With
    End If
    
    If xVal <> "" Then
    With EffectInfo
    .x = xVal
    .y = YVal
    .constantForce.lMagnitude = Strength
    End With
    End If
    
        di_effect(deviceid).Stop
        di_effect(deviceid).SetParameters EffectInfo, DIEP_DURATION Or DIEP_START
    
Else
    di_effect(deviceid).Stop
End If
Exit Sub


End Sub





Public Sub Init_FF(Optional Mhwnd As Long)
Dim tmpstr As String
Dim hwnd As Long
If Mhwnd <> 0 Then
    hwnd = Mhwnd
Else
    hwnd = Form1.hwnd
End If
 
Dim I As Integer, iAxes As Integer
Set dx = New DirectX8
Set di = dx.DirectInputCreate

Set diEnumDev = di.GetDIDevices(DI8DEVTYPE_GAMEPAD Or DI8DEVCLASS_GAMECTRL Or DI8DEVTYPE_JOYSTICK, DIEDFL_ATTACHEDONLY)
ReDim diDev(diEnumDev.GetCount) As DirectInputDevice8
ReDim di_effect(diEnumDev.GetCount) As DirectInputEffect

For I = 1 To diEnumDev.GetCount
    Set diDevInst = diEnumDev.GetItem(I)
    Set diDev(I) = di.CreateDevice(diDevInst.GetGuidInstance)
    Call diDev(I).GetCapabilities(devcaps)
    If devcaps.lFlags And DIDC_FORCEFEEDBACK Then
    'Process the force-feedback device




        'MsgBox i
        Set diDevObjEnum = diDev(I).GetDeviceObjectsEnum(DIDFT_AXIS)
     End If
 
 
 
 
    ForceX = False
    ForceY = False
    For iAxes = 1 To diDevObjEnum.GetCount
        Set devobj = diDevObjEnum.GetItem(iAxes)
        strObjGuid = devobj.GetGuidType
        If strObjGuid = "GUID_XAxis" Then
            If devobj.GetFlags And DIDOI_FFACTUATOR Then
                ForceX = True
            End If
        ElseIf strObjGuid = "GUID_YAxis" Then
            If devobj.GetFlags And DIDOI_FFACTUATOR Then
                ForceY = True
            End If
        End If
        FoundForce = ForceX And ForceY
        If FoundForce Then
            tmpstr = "Joystick Id#" + Trim(Str(I)) + "=" + diDevInst.GetProductName
            Form1.Text1.Text = Form1.Text1.Text + vbCrLf + tmpstr
            Call diDev(I).SetCommonDataFormat(DIFORMAT_JOYSTICK2)
            Call diDev(I).SetCooperativeLevel(hwnd, _
                    DISCL_BACKGROUND Or DISCL_EXCLUSIVE)
            ' Set range properties...
            Dim prop As DIPROPLONG
            prop.ldata = 0
            prop.lHow = DIPH_DEVICE
            prop.lObj = 0
            Call diDev(I).SetProperty("DIPROP_AUTOCENTER", prop)
             diDev(I).Acquire
            With EffectInfo
                .constantForce.lMagnitude = 100000
                
                .lDuration = -1       ' Infinite
                .x = 18000
                .lGain = 10000        ' Play at full magnitude
                .lTriggerButton = -1  ' No trigger button
            End With
            Set di_effect(I) = diDev(I).CreateEffect("GUID_ConstantForce", EffectInfo)
        
        End If
    Next iAxes

Next I    'Next device

















End Sub

Public Sub Stop_ff()
On Error Resume Next
Dim I As Integer
For I = 0 To UBound(diDev)
    diDev(I).Unacquire
Next I
End Sub




