Attribute VB_Name = "Module1"
Option Explicit
Public ids() As String
Public Hstart As String
Public Hstop As String
Public IdUbound As Integer
Public sBuffer(0 To 10) As String
Public Declare Function init_mame Lib "Mame" (ByVal id As Long, ByVal Name As String, ByVal MameStart As Long, ByVal MameStop As Long, ByVal MameCopyData As Long, ByVal UpdateState As Long) As Long
Public Declare Function close_mame Lib "Mame" () As Long
Public Declare Function map_id_to_outname Lib "Mame" (ByVal id As Long) As String

Public Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lsString As Any, ByVal lplFilename As String) As Long
Public Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPriviteProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Public Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long



Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)


Private Declare Function WaitForSingleObject Lib _
"kernel32" (ByVal hHandle As Long, ByVal dwMilliseconds _
As Long) As Long



Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject _
As Long) As Long

Private Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess _
As Long, ByVal bInheritHandle As Long, ByVal dwProcessID As Long) As Long
Private Const SYNCHRONIZE = &H100000
Private Const INFINITE = &HFFFF
Private Const NORMAL_PRIORITY_CLASS = &H20&
'Private Const INFINITE = -1&
'Private Const INFINITE = &HFFFF




Private Type RECT
  Left    As Long
  Top     As Long
  Right   As Long
  Bottom  As Long
End Type

Private Type POINTAPI
  x       As Long
  y       As Long
End Type

Private Type WINDOWPLACEMENT
  length            As Long
  Flags             As Long
  showCmd           As Long
  ptMinPosition     As POINTAPI
  ptMaxPosition     As POINTAPI
  rcNormalPosition  As RECT
End Type

Private Const SW_SHOWNORMAL = 1
Private Const SW_SHOWMINIMIZED = 2
Private Const SW_SHOWMAXIMIZED = 3
Private Const SW_SHOWNOACTIVATE = 4

Private Declare Function BringWindowToTop Lib "user32" _
  (ByVal hwnd As Long) As Long

Private Declare Function FindWindow Lib "user32" _
   Alias "FindWindowA" _
  (ByVal lpClassName As String, _
   ByVal lpWindowName As String) As Long
   
Private Declare Function GetWindowPlacement Lib "user32" _
   (ByVal hwnd As Long, lpwndpl As WINDOWPLACEMENT) As Long

Private Declare Function SetForegroundWindow Lib "user32" _
   (ByVal hwnd As Long) As Long

Private Declare Function SetWindowPlacement Lib "user32" _
   (ByVal hwnd As Long, lpwndpl As WINDOWPLACEMENT) As Long




Public Parsing As Boolean
Public needsGeneral As Boolean
Public PauseId As String

Public Function mame_start() As Long
    Form1.Text1.Text = ""
    Form1.Text1.Text = Form1.Text1.Text & "mame_start" & vbNewLine
    'we reset the ubound to 0 and redim our ids at every startup
   
    needsGeneral = False
    IdUbound = 0
    ReDim ids(5, 0) As String
    
    TurnOffLPTS
    frmDisplay.ClearDisplay
    FirstFF = True
    Parsing = False
    PauseId = "na"
    'BuffRead = False
    InitIow
End Function

Public Function mame_stop() As Long
    On Error Resume Next
    'MsgBox "mame stop"
    Form1.Text1.Text = Form1.Text1.Text + vbNewLine & "mame_stop" & vbNewLine
    PauseIt 1, 1
    Stop_ff
    'MsgBox "FF"
    KillIow
    frmDisplay.ClearDisplay
    
    'MsgBox "killiow"
    If ids(5, 0) <> "na" Then setState ids(5, 0), "1"
    'MsgBox "states"
End Function

Public Function Hooker_Stop() As Long
    
    
    If Hstop <> "na" Then setState Hstop, "1"
    
End Function

Public Function Hooker_Start() As Long
Dim ret As Long
Dim ReturnedValue As String * 2500
Dim svalue As String
'in hooker start we go ahead and get the values for both the start and stop of the app
ret = GetPrivateProfileString("General", "MameHookerStart", "na", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
svalue = Left(ReturnedValue, ret)
svalue = Trim(svalue)
Hstart = svalue

ret = GetPrivateProfileString("General", "MameHookerStop", "na", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
svalue = Left(ReturnedValue, ret)
svalue = Trim(svalue)
Hstop = svalue

'now we go ahead and run hstart if it exists

    If Hstart <> "na" Then setState Hstart, "1"
    
End Function


Public Function mame_copydata(ByVal id As Long, ByVal Name As String) As Long
   ' Form1.Text1.Text = Form1.Text1.Text & "id " & id & " = " & "'" & name & "'" & vbNewLine
    'we always fill the first row with the rom data
    If id = 0 Then
        ids(0, 0) = "0"
        ids(1, 0) = Name
        'note that we start getglobals here instead of at mamestart becuase the startup script might need the rom name
        GetGlobals
        'readIow
        'BuffRead = True
    End If
End Function

Public Function mame_updatestate(ByVal id As Long, ByVal state As Long) As Long
    'If Parsing = True Then Exit Function
    'Parsing = True
    Dim Name As String
    
    Name = GetName(id, state)
    'Form1.Text1.Text = Form1.Text1.Text & "update_state: id=" & id & " (" & name & ") state=" & State & vbNewLine
    UpdateDisplay
    'Parsing = False
End Function


Public Function GetName(id As Long, state As Long, Optional ForcedName = "") As String
Dim idSTR As String
Dim Name As String
idSTR = Trim(Str(id))
'note that the "pause" state is specially handeled
'we set everything to 0 to avoid solenoid damage
If idSTR = PauseId Then
    PauseIt state
    Exit Function
End If
Dim x As Integer
    For x = 0 To IdUbound
        If ids(0, x) = idSTR Then
            'we found a previous entry, so skip to the end and set the name
            GetName = ids(1, x)
            ids(2, x) = Trim(Str(state))
            GetBinding x
            x = IdUbound + 2
        End If
    Next x
    
    If x <> IdUbound + 3 Then
        'if it isn't +3 then we know it searched normally and didn't find anything
        If ForcedName = "" Then
            Name = map_id_to_outname(id)
        Else
            Name = ForcedName
        End If
        
        If Name <> "pause" Then
            ReDim Preserve ids(5, IdUbound + 1) As String
            IdUbound = IdUbound + 1
            ids(0, IdUbound) = idSTR
            ids(1, IdUbound) = Name
            ids(2, IdUbound) = Trim(Str(state))
            GetBinding IdUbound
            GetName = Name
        Else
            
            PauseId = Trim(Str(id))
            PauseIt state
        End If
    End If
End Function

Public Sub UpdateDisplay()

Dim junk As String
Dim x As Integer
junk = "Rom=" + ids(1, 0)
For x = 1 To IdUbound
    junk = junk + vbCrLf
    junk = junk + ids(0, x) + "=" + ids(1, x) + "=" + ids(2, x)
Next x
Form1.Text1.Text = junk

End Sub

Public Sub GetBinding(bIndex As Integer)
'3=rom
'4=parent rom
'5=default

Dim check As String


Dim ret As Long
Dim ReturnedValue As String * 2500
Dim svalue As String




'slot 3 in ids = the script found in the rom.ini, 4 is clone.ini, and 5 is default.ini

'if these three slots are blank, then we haven't searched yet and we need to
If ids(3, bIndex) = "" And ids(4, bIndex) = "" And ids(5, bIndex) = "" Then
    'first check the rom.ini for an entry
    ret = GetPrivateProfileString("Output", ids(1, bIndex), "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + ids(1, 0) + ".ini")
    svalue = Left(ReturnedValue, ret)
    svalue = Trim(svalue)
    
    
    If svalue = "" Then
        'if we didn't find one then create a blank one (which will also make the file)
        'set the value in our array to "na", so we know we searched
        'and finally start a search for an entry in default.ini
        If needsGeneral = True Then WriteGenerals App.Path + "\ini\" + ids(1, 0) + ".ini"
        WritePrivateProfileString "Output", ids(1, bIndex), "", App.Path + "\ini\" + ids(1, 0) + ".ini"
        'WritePrivateProfileString "Id2String", ids(0, bIndex), ids(1, bIndex), App.Path + "\ini\" + ids(1, 0) + ".ini"
        ids(3, bIndex) = "na"
        
        ret = GetPrivateProfileString("Output", ids(1, bIndex), "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
        svalue = Left(ReturnedValue, ret)
        svalue = Trim(svalue)
        If svalue = "" Then
            'if we didn't find on in default.ini then go ahed and make a blank entry
            'and set the array value to "na" so we know we searched
            WritePrivateProfileString "Output", ids(1, bIndex), "", App.Path + "\ini\" + "default" + ".ini"
            'WritePrivateProfileString "Id2String", ids(0, bIndex), ids(1, bIndex), App.Path + "\ini\" + "default" + ".ini"
            ids(5, bIndex) = "na"
            
        Else
            'if we found one in default.ini then store it in slot 5 of the array
            'and go ahead and use it by sending it off to setstate
            ids(5, bIndex) = svalue
            setState ids(5, bIndex), ids(2, bIndex)
            'we just changed a state, so we need to fire the statechange as well
            If ids(4, 0) <> "na" Then setState ids(4, 0), "1"
        End If
    Else
        'if we found one in rom.ini then store it in slot 3 of the array
        'and go ahed and use it by sending it off to setstate
        'note that we quit at this point
        'rom.ini is more accurate than default.ini and thus we don't have to waste time checking
        'default.ini if we already have a match
        ids(3, bIndex) = svalue
        setState ids(3, bIndex), ids(2, bIndex)
        'we just changed a state, so we need to fire the statechange as well
        If ids(4, 0) <> "na" Then setState ids(4, 0), "1"
    End If
       
    
    
Else
    'if our array already contains some data then there is no need to search the inis
    
    If ids(3, bIndex) <> "na" Then
        'if there is an entry for the rom.ini then send it to setstate
        setState ids(3, bIndex), ids(2, bIndex)
        'we just changed a state, so we need to fire the statechange as well
        If ids(4, 0) <> "na" Then setState ids(4, 0), "1"
    Else
        'if no rom.ini entry is found then
        If ids(4, bIndex) <> "" Then
            'if there is a clone entry (not implemented yet) then send it to setstate
            setState ids(4, bIndex), ids(2, bIndex)
            'we just changed a state, so we need to fire the statechange as well
            If ids(4, 0) <> "na" Then setState ids(4, 0), "1"
        Else
            If ids(5, bIndex) <> "na" Then
                'if there is a default.ini entry then send it to setstate
                setState ids(5, bIndex), ids(2, bIndex)
                'we just changed a state, so we need to fire the statechange as well
                If ids(4, 0) <> "na" Then setState ids(4, 0), "1"
            End If
        End If
    End If
End If
'Parsing = False
End Sub

Public Sub setState(script As String, state As String)
Dim x As Integer
'incoming is the state value retrieved by mame, and the entire script string
Dim script2 As String
'we should never get a blank entry, but some error handling never hurts
If script = "" Or script = "na" Then Exit Sub
'inject the state into the string where needed
script2 = Replace(script, "%s%", state)
If ids(1, 0) <> "" Then
script2 = Replace(script2, "%rom%", ids(1, 0))
End If

'incase a buffer is needed we inject those as well
For x = 0 To 10
    script2 = Replace(script2, "%b" + Trim(Str(x)) + "%", sBuffer(x))
Next x

script2 = Trim(script2)
Dim States
Dim Commands() As String

'in case each state has it's own set of commands, split by "|"
States = Split(script2, "|")

If UBound(States) = 0 Then
    'if there is only one command, then it must be using the state to set the device
    Commands = Split(States(0), ",")
    For x = 0 To UBound(Commands)
        SetOutput Commands(x)
    Next x
Else
    'otherwise there is a set of command(s) for each state
    'we are only concerened with the current state, so use the state value
    'to get our position in the array
    Commands = Split(States(Int(state)), ",")
    'now we split it by individual device/function commands as there can be many
    For x = 0 To UBound(Commands)
        'do each command in sequence
        SetOutput Commands(x)
    Next x
End If


End Sub

Public Sub SetOutput(Command As String)
If Command = "" Then Exit Sub
Dim Command2 As String
Dim x As Integer
Command2 = Command
Command2 = Replace(Command2, "%comma%", ",")
Command2 = Replace(Command2, "%rom%", ids(1, 0))
'the incoming string is a single command, parsed out by setState
Dim idkey As String
'get the device/function type by finding the first three letters
Command2 = Trim(Command2)
idkey = LCase(Left(Command2, 3))
'remove those letters from the command so we are left with nothing but variables
Command2 = Right(Command2, Len(Command2) - 4)
Dim Vars
'the variables are seperated by spaces, so let's split them
Vars = Split(Command2, " ")

Dim tmpText As String, tmpText2 As String

Select Case idkey
    Case Is = "lwp"
        'ledwiz intensity setting
        Form1.LED_Wiz.DeviceNumber = Int(Vars(0))
        Form1.LED_Wiz.Command = "P" + Vars(1) + ":" + Vars(2)
    Case Is = "lws"
        'ledwiz on/off state setting
        Form1.LED_Wiz.DeviceNumber = Int(Vars(0))
        Form1.LED_Wiz.Command = "S" + Vars(1) + ":" + Vars(2)
    Case Is = "lwc"
        'ledwiz rgb setting
        Form1.LED_Wiz.DeviceNumber = Int(Vars(0))
        Form1.LED_Wiz.Command = "RGB:" + Vars(1) + "," + Vars(2) + "," + Vars(3) + "," + Vars(4)
    Case Is = "lwk"
        'turn off all leds
        Form1.LED_Wiz.DeviceNumber = Int(Vars(0))
        Form1.LED_Wiz.Command = "SBA:0,0,0,0,1"
    
    Case Is = "pds"
        'pac-drive on/off state Settings
        pdSetLED Int(Vars(0)), Int(Vars(1)), Int(Vars(2))
    Case Is = "pdk"
        'pac-drive turn off all leds
        pdKill Int(Vars(0))
    
    Case Is = "iws"
        'i/o warrior on/off state setting
        iowSetLed Int(Vars(0)), 0, Int(Vars(1)), Int(Vars(2))
    Case Is = "iwc"
        'i/o warrior rgb(digital only)setting
        iowSetLed Int(Vars(0)), 0, Int(Vars(1)), Int(Vars(2)), Int(Vars(3)), Int(Vars(4))
        
    Case Is = "iwr"
        '0 = iowarrior
        '1 = mala
        '2 = ledwiz hack
        ReadIOW Int(Vars(0)), 0
    Case Is = "iwk"
        iowBufferAllOff Int(Vars(0))
        Call WriteLEDs(Int(Vars(0)), 255, 255, 255, 255, 255, 255, 255)
        For x = 1 To 56
            iowBuffer(Int(Vars(0)), x) = "1"
        Next x
    Case Is = "mls"
        'mala  on/off state setting
        
        
        iowSetLed Int(Vars(0)), 1, Int(Vars(1)), Int(Vars(2))
    Case Is = "mlc"
        'mala rgb(digital only)setting
        iowSetLed Int(Vars(0)), 1, Int(Vars(1)), Int(Vars(2)), Int(Vars(3)), Int(Vars(4))
    
    Case Is = "mlr"
        '0 = iowarrior
        '1 = mala
        '2 = ledwiz hack
        ReadIOW Int(Vars(0)), 1
    
    Case Is = "mlk"
        iowBufferAllOff Int(Vars(0))
        Call WriteLEDs(Int(Vars(0)), 0, 0, 0, 0, 0, 0, 0)
        For x = 1 To 56
            iowBuffer(Int(Vars(0)), x) = "0"
        Next x
    
    Case Is = "lhs"
        'ledwiz io warrior hack  on/off state setting
        
        
        iowSetLed Int(Vars(0)), 2, Int(Vars(1)), Int(Vars(2))
    Case Is = "lhc"
        'ledwiz io warrior rgb(digital only)setting
        iowSetLed Int(Vars(0)), 2, Int(Vars(1)), Int(Vars(2)), Int(Vars(3)), Int(Vars(4))
    
    Case Is = "lhr"
        '0 = iowarrior
        '1 = mala
        '2 = ledwiz hack
        ReadIOW Int(Vars(0)), 2
    
    Case Is = "lhk"
        iowBufferAllOff Int(Vars(0))
        Call WriteLEDs(Int(Vars(0)), 0, 0, 0, 0, 0, 0, 0)
        For x = 1 To 56
            iowBuffer(Int(Vars(0)), x) = "0"
        Next x
    Case Is = "lpt"
        RawLptOut Int(Vars(0)), Int(Vars(1))
    
    Case Is = "lpe"
        ChangeLPTLED Int(Vars(2)), Int(Vars(1)), Int(Vars(0))
        LightLPT
        
    Case Is = "kbd"
        ChangeKbdLED Int(Vars(1)), Int(Vars(0))
        
    Case Is = "dff"
        Rumble_State Int(Vars(0)), Int(Vars(1)), Int(Vars(2))
    Case Is = "ffa"
        Rumble_State Int(Vars(0)), Int(Vars(1)), Int(Vars(2)), Int(Vars(3)), Int(Vars(4)), Int(Vars(5))
    Case Is = "wii"
     'set a buffer
    
    Case Is = "lds"
        
        frmDisplay.LoadDis Vars(0)
    Case Is = "sds"
        frmDisplay.setImage Int(Vars(0)), Int(Vars(1))
    
    Case Is = "sbf"
        'we replace underscores with spaces and then set the buffer
        tmpText = Replace(Vars(1), "_", " ")
        sBuffer(Int(Vars(0))) = tmpText
        Debug.Print tmpText
    'inject a digit
    Case Is = "ibf"
    'we are replacing a single digit with a single digit, so we have to change anything else to a space.
    If Len(Vars(2)) > 1 Then
        tmpText2 = " "
    Else
        tmpText2 = Vars(2)
    End If
    'we basically make a new string by taking everything before the injection point, the new digit, and everything after
    tmpText = Left(sBuffer(Int(Vars(0))), Int(Vars(1)) - 1) + tmpText2 + Right(sBuffer(Int(Vars(0))), Len(sBuffer(Int(Vars(0)))) - Int(Vars(1)))
    
    sBuffer(Int(Vars(0))) = tmpText
    Debug.Print tmpText
    'a null command
    Case Is = "nll"
    Case Is = "wat"
        Sleep Vars(0)
        
    Case Is = "cmo"
        tmpText = Replace(Vars(1), "_", " ")
        COpen Vars(0), tmpText
    Case Is = "cmc"
        CClose Vars(0)
    Case Is = "cmr"
        CRead Vars(0), Vars(1), Vars(2)
    Case Is = "cmw"
        tmpText = Replace(Vars(1), "_", " ")
        CWrite Vars(0), tmpText
    Case Is = "css"
        tmpText = Replace(Vars(1), "_", " ")
        CSetState Vars(0), tmpText
    Case Is = "csl"
        CSetLine Vars(0), Vars(1), Vars(2), Vars(3)
    Case Is = "rfs"
        ReadFromScript Vars(0), Vars(1), Vars(2)
    Case Is = "cmd"
        'path 'exe 'options
        Vars(0) = Replace(Vars(0), "_", " ")
        Vars(1) = Replace(Vars(1), "_", " ")
        Vars(2) = Replace(Vars(2), "_", " ")
        Vars(3) = Replace(Vars(3), "_", " ")
        ShellCommand Vars(0), Vars(1), Vars(2), Vars(3)
    Case Is = "cdw"
        Vars(0) = Replace(Vars(0), "_", " ")
        Vars(1) = Replace(Vars(1), "_", " ")
        Vars(2) = Replace(Vars(2), "_", " ")
        Vars(3) = Replace(Vars(3), "_", " ")
        ShellAndWait Vars(0), Vars(1), Vars(2), Vars(3)
    Case Is = "rwi"
        Vars(0) = Replace(Vars(0), "_", " ")
        Vars(1) = Replace(Vars(1), "_", " ")
        
        RestoreWindow Vars(0), Vars(1)
    Case Is = "qut"
        KillDDE
        Sleep 1000
        Form1.mpopExit_Click
End Select


End Sub


Public Sub GetGlobals()
'3=rom
'4=parent rom
'5=default
Dim check As String


Dim ret As Long
Dim ReturnedValue As String * 2500
Dim svalue As String

'The three extra slots at 0 are used for global scripts
'3=mamestart
'4=statechagne
'5=mamestop

    'first we search and fill mamestart
    ret = GetPrivateProfileString("General", "MameStart", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + ids(1, 0) + ".ini")
    svalue = Left(ReturnedValue, ret)
    svalue = Trim(svalue)
    If svalue = "" Then
        needsGeneral = True
        ret = GetPrivateProfileString("General", "MameStart", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
        svalue = Left(ReturnedValue, ret)
        svalue = Trim(svalue)
    End If
    
    If svalue = "" Then
        ids(3, 0) = "na"
        
    Else
        ids(3, 0) = svalue
        'well we just started up, so we might as well fire the event now that it's found
        setState ids(3, 0), "1"
    End If
    
    'now we search and fill statechange'
    ret = GetPrivateProfileString("General", "StateChange", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + ids(1, 0) + ".ini")
    svalue = Left(ReturnedValue, ret)
    svalue = Trim(svalue)
    If svalue = "" Then
        ret = GetPrivateProfileString("General", "StateChange", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
        svalue = Left(ReturnedValue, ret)
        svalue = Trim(svalue)
    End If
    
    If svalue = "" Then
        ids(4, 0) = "na"
        
    Else
        ids(4, 0) = svalue
       'no states have been changed yet so we don't fire anything
        
    End If
    
    'now we search and fill mamestop'
    ret = GetPrivateProfileString("General", "MameStop", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + ids(1, 0) + ".ini")
    svalue = Left(ReturnedValue, ret)
    svalue = Trim(svalue)
    If svalue = "" Then
        ret = GetPrivateProfileString("General", "MameStop", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
        svalue = Left(ReturnedValue, ret)
        svalue = Trim(svalue)
    End If
    
    If svalue = "" Then
        ids(5, 0) = "na"
        
    Else
        ids(5, 0) = svalue
              
    End If
    
    
    
   
End Sub

Public Sub WriteGenerals(iPath As String)
Dim ret As Long
Dim ReturnedValue As String * 2500
Dim svalue As String
'One or more of the general entries were missing so we read them all in and write them back out,
'essentially creating blank entries for any missing keys.

ret = GetPrivateProfileString("General", "MameStart", "", ReturnedValue, Len(ReturnedValue), iPath)
svalue = Left(ReturnedValue, ret)
svalue = Trim(svalue)
WritePrivateProfileString "General", "MameStart", svalue, iPath

ret = GetPrivateProfileString("General", "MameStop", "", ReturnedValue, Len(ReturnedValue), iPath)
svalue = Left(ReturnedValue, ret)
svalue = Trim(svalue)
WritePrivateProfileString "General", "MameStop", svalue, iPath

ret = GetPrivateProfileString("General", "StateChange", "", ReturnedValue, Len(ReturnedValue), iPath)
svalue = Left(ReturnedValue, ret)
svalue = Trim(svalue)
WritePrivateProfileString "General", "StateChange", svalue, iPath
needsGeneral = False
End Sub

Public Sub PauseIt(pState As Long, Optional JustExit As Integer = 0)
Dim x As Integer
'this function is pretty straight forward
'just keep in mind that if pause=1 then we turn everything off
'if it's 0, however we have to set the actual state of the device.
If pState = 1 Then
    For x = 1 To IdUbound
        If ids(3, x) <> "na" And ids(3, x) <> "" Then
            setState ids(3, x), "0"
        Else
            If ids(4, x) <> "na" And ids(4, x) <> "" Then
                setState ids(4, x), "0"
            Else
                If ids(5, x) <> "na" And ids(5, x) <> "" Then
                    setState ids(5, x), "0"
                End If
            End If
        End If
    Next x
    If JustExit = 0 Then RunPauseScript "1"
Else
    For x = 1 To IdUbound
        If ids(3, x) <> "na" And ids(3, x) <> "" Then
            setState ids(3, x), ids(2, x)
        Else
            If ids(4, x) <> "na" And ids(4, x) <> "" Then
                setState ids(4, x), ids(2, x)
            Else
                If ids(5, x) <> "na" And ids(5, x) <> "" Then
                    setState ids(5, x), ids(2, x)
                End If
            End If
        End If
    Next x
    If JustExit = 0 Then RunPauseScript "0"
End If


End Sub

Public Sub ReadFromScript(scriptName, sDelay, cState)
Dim sPath As String
Dim check As String
Dim TmpWait As String
Dim FileText As String
Dim TmpState As String
TmpState = cState

sPath = App.Path + "\scripts\" + scriptName + ".mhs"

check = Dir(sPath, vbNormal)

If check <> "" Then
    Dim handle As Integer
    handle = FreeFile
    Open sPath For Input As #handle
    FileText = Input$(LOF(handle), handle)
    Close #handle
    
    FileText = Replace(FileText, vbCrLf + "BREAK" + vbCrLf, "|")
    FileText = Replace(FileText, vbCrLf + "BREAK", "|")
    If sDelay = "0" Then
        TmpWait = ","
    Else
        TmpWait = ",wat " + sDelay + ","
    End If
    FileText = Replace(FileText, vbCrLf, TmpWait)
    setState FileText, TmpState
End If

End Sub

Public Sub RunPauseScript(pState As String)
Dim ret As Long
Dim ReturnedValue As String * 2500
Dim svalue As String

    ret = GetPrivateProfileString("General", "Pause", "", ReturnedValue, Len(ReturnedValue), App.Path + "\ini\" + "default" + ".ini")
    svalue = Left(ReturnedValue, ret)
    svalue = Trim(svalue)
    If svalue <> "" Then setState svalue, pState
End Sub

Public Sub ShellCommand(cPath, cExe, cOptions, cWState)

Dim windowState As Integer
If Left(cPath, 1) = "\" Then cPath = App.Path + cPath
windowState = Int(cWState)
ChDrive cPath
ChDir cPath

If cOptions = "" Then
Shell cExe, windowState
Else
Shell cExe + " " + cOptions, windowState
End If
'RestoreWindow , "MAME"
End Sub

Public Sub ShellAndWait(cPath, cExe, cOptions, cWState)

Dim windowState As Integer
If Left(cPath, 1) = "\" Then cPath = App.Path + cPath
Dim ShellId, ShellHandle, ret

windowState = Int(cWState)
ChDrive cPath
ChDir cPath

If cOptions = "" Then

ShellId = Shell(cExe, windowState)
Else

ShellId = Shell(cExe + " " + cOptions, windowState)
End If


    ShellHandle = OpenProcess(SYNCHRONIZE, 0, ShellId)
    Sleep 200
    If ShellHandle <> 0 Then
        
        ret = WaitForSingleObject(ShellHandle, INFINITE)
        ret = CloseHandle(ShellHandle)
    End If
   
'RestoreWindow , "MAME"


End Sub

Public Sub ShowDevices()
Form1.Text1.Text = ""
Form1.Text1.Text = "Force Feedback Devices" + vbCrLf + "-------------------------"
Init_FF
Stop_ff
Form1.Text1.Text = Form1.Text1.Text + vbCrLf + vbCrLf + "LedWiz Devices" + vbCrLf + "-------------------------"
GetledWizzes
Form1.Text1.Text = Form1.Text1.Text + vbCrLf + vbCrLf + "IoWarrior Devices" + vbCrLf + "-------------------------"
InitIow
KillIow
Form1.Show
End Sub

Public Sub GetledWizzes()
    Dim tmpstr As String
    Dim x As Integer
    tmpstr = Form1.LED_Wiz.Detected
    For x = 1 To 16
        If Mid(tmpstr, x, 1) = "1" Then
            Form1.Text1.Text = Form1.Text1.Text + vbCrLf + "LedWiz#" + Trim(Str(x))
        End If
    Next x
End Sub

Private Sub RestoreWindow(Optional sWindowTitle = vbNullString, Optional winClass = vbNullString)

   Dim hWndCtlApp As Long
   Dim currWinP As WINDOWPLACEMENT
    If sWindowTitle = " " Then sWindowTitle = vbNullString
    If winClass = " " Then winClass = vbNullString
  'obtain the handle to the control app
   hWndCtlApp = FindWindow(winClass, sWindowTitle)
   
   If hWndCtlApp Then
   
   
     'prepare the WINDOWPLACEMENT type
      currWinP.length = Len(currWinP)
   
      If GetWindowPlacement(hWndCtlApp, currWinP) > 0 Then
      
        'determine the window state
         If currWinP.showCmd = SW_SHOWMINIMIZED Then
      
           'minimized, so restore
            currWinP.length = Len(currWinP)
            currWinP.Flags = 0&
            currWinP.showCmd = SW_SHOWNORMAL
            Call SetWindowPlacement(hWndCtlApp, currWinP)
         
         Else
           
           'on screen, so assure visible
            Call SetForegroundWindow(hWndCtlApp)
            Call BringWindowToTop(hWndCtlApp)
         
         End If
      
      End If
   
   End If
   
End Sub


Public Sub Main()
If InDbg = False Then InitDDE
'InitDDE
Load Form1
End Sub
Private Function InDbg() As Boolean
  On Error Resume Next
  Debug.Assert 1 / 0
  InDbg = (Err <> 0)
  If InDbg = True Then MsgBox "DDE Will Not Work in Development Mode"
End Function
