Attribute VB_Name = "ComPorts"
' CommIO.vb -- Example of using CommIO.dll
' Written by Ben Baker

Option Explicit

Public Const COM1 As Integer = 1
Public Const COM2 As Integer = 2
Public Const COM3 As Integer = 3
Public Const COM4 As Integer = 4 ' You can go up to 256 ports
Public Const LINE_BREAK As Integer = 1
Public Const LINE_DTR As Integer = 2
Public Const LINE_RTS As Integer = 3

Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Declare Function CommIsOpen Lib "CommIO" (ByVal iPortNum As Integer) As Boolean
Declare Sub IsCommOpen Lib "CommIO" Alias "CommIsOpen" (ByVal dwErrorCode As Long, ByVal sMsg As String)
Declare Function CommOpen Lib "CommIO" (ByVal iPortNum As Integer, ByVal sSettings As String) As Integer
Declare Function CommSetState Lib "CommIO" (ByVal iPortNum As Integer, ByVal sSettings As String) As Integer
Declare Function CommClose Lib "CommIO" (ByVal iPortNum As Integer) As Integer
Declare Function CommFlush Lib "CommIO" (ByVal iPortNum As Integer) As Integer
Declare Function CommRead Lib "CommIO" (ByVal iPortNum As Integer, ByVal sData As String, ByVal dwSize As Long) As Integer
Declare Function CommWrite Lib "CommIO" (ByVal iPortNum As Integer, ByVal sData As String) As Integer
Declare Function CommGetLine Lib "CommIO" (ByVal iPortNum As Integer, ByVal iLine As Integer, ByVal bState As Boolean) As Integer
Declare Function CommSetLine Lib "CommIO" (ByVal iPortNum As Integer, ByVal iLine As Integer, ByVal bState As Boolean) As Integer
Declare Function CommGetError Lib "CommIO" (ByVal sMsg As String) As Integer




Public Sub COpen(ByVal cPort As Integer, ByVal sSettings As String)
If CommIsOpen(cPort) = False Then
    CommOpen cPort, sSettings
    CSetLine cPort, 0, 1, 1
End If
End Sub

Public Sub CSetState(ByVal cPort As Integer, ByVal cSettings As String)
If CommIsOpen(cPort) = True Then
    CommSetState cPort, cSettings
End If
End Sub


Public Sub CClose(cPort)
If CommIsOpen(cPort) Then
    CommClose cPort
End If
End Sub

Public Sub CRead(ByVal cPort As Integer, ByVal cBuff As String, ByVal cSize As Long)

    If CommIsOpen(cPort) Then
        Dim ret As Integer
        Dim TmpBuff As String
        TmpBuff = Space(cSize)
        ret = CommRead(cPort, TmpBuff, cSize)
        sbuffer(cBuff) = Left(TmpBuff, ret)
    End If
End Sub

Public Sub CWrite(ByVal cPort As Integer, ByVal cString As String)
    If CommIsOpen(cPort) Then
        CommWrite cPort, cString
    End If
End Sub

Public Sub CSetLine(ByVal cPort As Integer, ByVal cLine As Integer, ByVal cDTR As Integer, ByVal cRTS As Integer)
    If CommIsOpen(cPort) Then
        CommSetLine COM1, LINE_BREAK, cLine
        CommSetLine COM1, LINE_DTR, cDTR
        CommSetLine COM1, LINE_RTS, cRTS
        
    End If
End Sub

