Attribute VB_Name = "LEDs"
Public Const VK_CAPITAL = &H14
Public Const VK_NUMLOCK = &H90
Public Const VK_SCROLL = &H91
Public Const VK_USED = VK_SCROLL

Public LptBuffer(1 To 2, 1 To 8) As Integer
Public Const Lpt1 = 888
Public Const Lpt2 = 623


Public Const KEYEVENTF_EXTENDEDKEY = &H1
Public Const KEYEVENTF_KEYUP = &H2


Public Declare Function GetKeyState Lib "user32" (ByVal nVirtKey As Long) As Long
'Public kbArray As KeyboardBytes, CapsLock As Boolean, kbOld As KeyboardBytes
Public LedVals(1 To 3) As Long

Public Declare Sub keybd_event Lib "user32" (ByVal bVk As Byte, ByVal bScan As Byte, ByVal dwFlags As Long, ByVal dwExtraInfo As Long)


Public Declare Function Inp Lib "inpout32.dll" _
Alias "Inp32" (ByVal PortAddress As Integer) As Integer
Public Declare Sub Out Lib "inpout32.dll" _
Alias "Out32" (ByVal PortAddress As Integer, ByVal Value As Integer)



Public Sub ChangeKbdLED(Kstate As Integer, KIndex As Integer, Optional DefS As Integer = 0)
LedVals(1) = VK_NUMLOCK
LedVals(2) = VK_CAPITAL
LedVals(3) = VK_SCROLL

If DefS <> 0 And Kstate = 0 Then Kstate = DefS

junk = GetKeyState(LedVals(KIndex))

If (junk = 0 And Kstate <> 0) Or (junk <> 0 And Kstate = 0) Then
    keybd_event LedVals(KIndex), &H45, _
                KEYEVENTF_EXTENDEDKEY Or 0, 0
           
    keybd_event LedVals(KIndex), &H45, KEYEVENTF_EXTENDEDKEY _
    Or KEYEVENTF_KEYUP, 0

End If
End Sub

Public Sub ChangeLPTLED(Kstate As Integer, KIndex As Integer, Kport, Optional DefS As Integer = 0)
LedVals(1) = VK_NUMLOCK
LedVals(2) = VK_CAPITAL
LedVals(3) = VK_SCROLL

If DefS <> 0 And Kstate = 0 Then Kstate = DefS



LptBuffer(Kport, KIndex) = Kstate
End Sub

Public Sub LightLPT()
tmpBuffer = 0
tmpBuffer2 = 0
lightsome = False
For x = 1 To 8
    If LptBuffer(1, x) > -1 Then
        lightsome = True
        x = 9
    End If
Next x
If lightsome = True Then
    If LptBuffer(1, 1) > 0 Then tmpBuffer = tmpBuffer + 1
    If LptBuffer(1, 2) > 0 Then tmpBuffer = tmpBuffer + 2
    If LptBuffer(1, 3) > 0 Then tmpBuffer = tmpBuffer + 4
    If LptBuffer(1, 4) > 0 Then tmpBuffer = tmpBuffer + 8
    If LptBuffer(1, 5) > 0 Then tmpBuffer = tmpBuffer + 16
    If LptBuffer(1, 6) > 0 Then tmpBuffer = tmpBuffer + 32
    If LptBuffer(1, 7) > 0 Then tmpBuffer = tmpBuffer + 64
    If LptBuffer(1, 8) > 0 Then tmpBuffer = tmpBuffer + 256
    Out Lpt1, Val(tmpBuffer)
End If


lightsome = False
For x = 1 To 8
    If LptBuffer(2, x) > -1 Then
        lightsome = True
        x = 9
    End If
Next x


If lightsome = True Then
    If LptBuffer(2, 1) > 0 Then tmpBuffer2 = tmpBuffer2 + 1
    If LptBuffer(2, 2) > 0 Then tmpBuffer2 = tmpBuffer2 + 2
    If LptBuffer(2, 3) > 0 Then tmpBuffer2 = tmpBuffer2 + 4
    If LptBuffer(2, 4) > 0 Then tmpBuffer2 = tmpBuffer2 + 8
    If LptBuffer(2, 5) > 0 Then tmpBuffer2 = tmpBuffer2 + 16
    If LptBuffer(2, 6) > 0 Then tmpBuffer2 = tmpBuffer2 + 32
    If LptBuffer(2, 7) > 0 Then tmpBuffer2 = tmpBuffer2 + 64
    If LptBuffer(2, 8) > 0 Then tmpBuffer2 = tmpBuffer2 + 256
    Out Lpt2, Val(tmpBuffer2)
End If
End Sub


Public Sub ResetLPT()

lightsome = False
For x = 1 To 8
   For Y = 1 To 2
        LptBuffer(Y, x) = -1
   Next Y
        
    
Next x

End Sub

Public Sub TurnOffLPTS()

lightsome = False
For x = 1 To 8
   For Y = 1 To 2
        LptBuffer(Y, x) = -1
   Next Y
    Out Lpt1, Val(0)
    Out Lpt2, Val(0)
Next x

End Sub





Public Sub RawLptOut(lptNumber As Integer, ldata As Integer)
If lptNumber = 1 Then
    Out Lpt1, ldata
Else
    Out Lpt2, ldata
End If
End Sub



