Attribute VB_Name = "ioWarrior"
' Required kernel32 functions
Public Declare Function GetLastError _
    Lib "kernel32" () _
As Long

' IOW SDK V1.5

' IO-Warrior vendor & product IDs
Public Const IOWKIT_VENDOR_ID As Long = &H7C0
Public Const IOWKIT_VID As Long = IOWKIT_VENDOR_ID

' IO-Warrior 40
Public Const IOWKIT_PRODUCT_ID_IOW40 As Long = &H1500
Public Const IOWKIT_PID_IOW40 As Long = IOWKIT_PRODUCT_ID_IOW40

' IO-Warrior 24
Public Const IOWKIT_PRODUCT_ID_IOW24 As Long = &H1501
Public Const IOWKIT_PID_IOW24 As Long = IOWKIT_PRODUCT_ID_IOW24

' IO-Warrior PowerVampire
Public Const IOWKIT_PRODUCT_ID_IOWPV1 As Long = &H1511
Public Const IOWKIT_PID_IOWPV1 As Long = IOWKIT_PRODUCT_ID_IOWPV1
Public Const IOWKIT_PRODUCT_ID_IOWPV2 As Long = &H1512
Public Const IOWKIT_PID_IOWPV2 As Long = IOWKIT_PRODUCT_ID_IOWPV2

' IO-Warrior 56
Public Const IOWKIT_PRODUCT_ID_IOW56 As Long = &H1503
Public Const IOWKIT_PID_IOW56 As Long = IOWKIT_PRODUCT_ID_IOW56

' Max number of pipes per IOW device
Public Const IOWKIT_MAX_PIPES As Long = 2

' pipe names
Public Const IOW_PIPE_IO_PINS As Long = 0
Public Const IOW_PIPE_SPECIAL_MODE As Long = 1

' Max number of IOW devices in system
Public Const IOWKIT_MAX_DEVICES As Long = 16

' IOW Legacy devices open modes
Public Const IOW_OPEN_SIMPLE As Long = 1
Public Const IOW_OPEN_COMPLEX As Long = 2

' first IO-Warrior revision with serial numbers
Public Const IOW_NON_LEGACY_REVISION = &H1010

' IO-Warrior low-level library API functions

Public Declare Function IowKitOpenDevice _
    Lib "iowkit" () _
As Long

Public Declare Sub IowKitCloseDevice _
    Lib "iowkit" _
    (ByVal iowHandle As Long)

Public Declare Function IowKitWrite _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByVal numPipe As Long, _
     ByRef buffer As Byte, _
     ByVal length As Long _
    ) _
As Long

Public Declare Function IowKitRead _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByVal numPipe As Long, _
     ByRef buffer As Byte, _
     ByVal length As Long _
    ) _
As Long

Public Declare Function IowKitReadNonBlocking _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByVal numPipe As Long, _
     ByRef buffer As Byte, _
     ByVal length As Long _
    ) _
As Long

Public Declare Function IowKitReadImmediate _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByRef Value As Long) _
As Long

' Get number of IOW devices
Public Declare Function IowKitGetNumDevs _
    Lib "iowkit" () _
As Long

' Get Nth IOW device handle
Public Declare Function IowKitGetDeviceHandle _
    Lib "iowkit" _
    (ByVal numDevice As Long) _
As Long

Public Declare Function IowKitSetLegacyOpenMode _
    Lib "iowkit" _
    (ByVal openMode As Long) _
As Long

Public Declare Function IowKitGetProductId _
    Lib "iowkit" _
    (ByVal iowHandle As Long) _
As Long

Public Declare Function IowKitGetRevision _
    Lib "iowkit" _
    (ByVal iowHandle As Long) _
As Long

Public Declare Function IowKitGetThreadHandle _
    Lib "iowkit" _
    (ByVal iowHandle As Long) _
As Long

Public Declare Function IowKitGetSerialNumber _
    Lib "iowkit" _
    (ByVal iowHandle As Long, ByRef serialNumber As Byte) _
As Long

Public Declare Function IowKitSetTimeout _
    Lib "iowkit" _
    (ByVal iowHandle As Long, ByVal TimeOut As Long) _
As Long

Public Declare Function IowKitSetWriteTimeout _
    Lib "iowkit" _
    (ByVal iowHandle As Long, ByVal TimeOut As Long) _
As Long

Public Declare Function IowKitCancelIo _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByVal numPipe As Long) _
As Long


' IO-Warrior handles
Dim iowHandles(IOWKIT_MAX_DEVICES) As Long
' Number of IOWs
Dim numIows As Long



'This isn't a byte buffer, but a 0/1 state buffer.
'iow actually is active low, so we use a 0 for on and a 1 for off
Public iowBuffer(0 To 16, 1 To 56) As Integer


' Basic data buffer is 8 bytes long: 1 byte for report id, max 7 bytes for data
Dim data(8) As Byte

'Public BuffRead As Boolean

Public Sub iowSetLed(ldevice As Integer, hwtype As Integer, lposition As Integer, lvalue As Integer, Optional lvalue2 As Integer = -1, Optional lvalue3 As Integer = -1)
'first we invert the value due to active low

Dim tmpval As String
Dim x As Integer, y As Integer

If hwtype = 0 Then

If lvalue = 0 Then
    lvalue = 1
Else
    lvalue = 0
End If
'now we update or 56 position array of states
iowBuffer(ldevice, lposition) = lvalue
'the iowarrior uses inverted digits, the other two don't

    If lvalue2 <> -1 Then
        If lvalue2 = 0 Then
            lvalue2 = 1
        Else
            lvalue2 = 0
        End If
        iowBuffer(ldevice, lposition + 1) = lvalue2
    End If
    
    If lvalue3 <> -1 Then
        If lvalue3 = 0 Then
            lvalue3 = 1
        Else
            lvalue3 = 0
        End If
        iowBuffer(ldevice, lposition + 2) = lvalue3
    End If
Else
    iowBuffer(ldevice, lposition) = lvalue
    If lvalue2 <> -1 Then iowBuffer(ldevice, lposition + 1) = lvalue2
    If lvalue3 <> -1 Then iowBuffer(ldevice, lposition + 2) = lvalue3
End If
'create the 7 banks
Dim tmpbuffer(1 To 7) As String
For x = 1 To 7
    tmpval = ""
    For y = (((x - 1) * 8) + 1) To (((x - 1) * 8) + 1) + 7
        tmpval = tmpval + Trim(Str(iowBuffer(ldevice, y)))
    Next y
    tmpbuffer(x) = tmpval
Next x
    WriteBanks ldevice, hwtype
'write the leds
'WriteLEDs ldevice, hwtype, tmpbuffer(1), tmpbuffer(2), tmpbuffer(3), tmpbuffer(4), tmpbuffer(5), tmpbuffer(6), tmpbuffer(7)
End Sub



Public Sub iowBufferAllOff(ldevice As Integer)
Dim x As Integer
For x = 1 To 56
    iowBuffer(ldevice, x) = 0
Next x
End Sub

Public Sub iowbufferAllOn(ldevice As Integer)
Dim x As Integer
For x = 1 To 56
    iowBuffer(ldevice, x) = 1
Next x
End Sub

Function BinToDec(Value) As Long
    Dim result As Long, i As Integer, exponent As Integer
    For i = Len(Value) To 1 Step -1
        Select Case Asc(Mid$(Value, i, 1))
            Case 48      ' "0", do nothing
            Case 49      ' "1", add the corresponding power of 2
                result = result Or Power2(exponent)
            Case Else
                Err.Raise 5      ' Invalid procedure call or argument
        End Select
        exponent = exponent + 1
    Next
    BinToDec = result
End Function

Public Function DecToBin(DeciValue, Optional NoOfBits As Integer = 8) As String
'********************************************************************************
'* Name : DecToBin'* Date : 2003'* Author : Alex Etchells
'*********************************************************************************
  Dim i As Integer  'make sure there are enough bits to contain the number
Do While DeciValue > (2 ^ NoOfBits) - 1
NoOfBits = NoOfBits + 8
Loop
DecToBin = vbNullString
'build the string
For i = 0 To (NoOfBits - 1)
DecToBin = CStr((DeciValue And 2 ^ i) / 2 ^ i) & DecToBin
Next i
End Function

Function Power2(ByVal exponent As Long) As Long
    Static res(0 To 31) As Long
    Dim i As Long
    
    ' rule out errors
    If exponent < 0 Or exponent > 31 Then Err.Raise 5
    
    ' initialize the array at the first call
    If res(0) = 0 Then
        res(0) = 1
        For i = 1 To 30
            res(i) = res(i - 1) * 2
        Next
        ' this is a special case
        res(31) = &H80000000
    End If
    
    ' return the result
    Power2 = res(exponent)
        
End Function


Public Sub InitIow()
On Error Resume Next
Dim i As Long
    Dim S(18) As Byte

    ' Initialize everything
    ' Open device
    iowHandles(0) = IowKitOpenDevice()
    
    ' Fail if can't open
    If iowHandles(0) = 0 Then
        ' Barf and exit from program
        Debug.Print "Can not open device!", 0, "Error"
        'MsgBox "Can not open Io Warrior!"
        Exit Sub
    End If
    ' Get number of IO-Warrior devices in system
    numIows = IowKitGetNumDevs()
    ' Get all IO-Warrior handles
    Form1.Text1.Text = Form1.Text1.Text + vbCrLf + "IoWarrior#" + "1"
    For i = 2 To numIows
        Form1.Text1.Text = Form1.Text1.Text + vbCrLf + "IoWarrior#" + Trim(Str(i))
        iowHandles(i - 1) = IowKitGetDeviceHandle(i)
        iowBufferAllOff (i)
    Next i
    
    'I = IowKitGetSerialNumber(iowHandles(0), S(0))
    'ReadLabel.Caption = S
    'ReadLabel.Caption = "Serial number: " + ReadLabel.Caption
    'ReadLabel.Refresh
End Sub




Public Sub WriteLEDs(ldevice As Integer, Value As Byte, Optional value2 As Byte = 0, Optional value3 As Byte = 0, Optional value4 As Byte = 0, Optional value5 As Byte = 0, Optional value6 As Byte = 0, Optional value7 As Byte = 0)
    ' Number of bytes written
    Dim nWritten As Long
    ' Loop variable
    Dim i As Long
    ' ProductID of IOWarrior
    Dim Pid As Long

    ' Set up Report ID
    data(0) = 0
    
        ' Set up bytes
        data(1) = Value
        data(2) = value2
        data(3) = value3
        data(4) = value4
        data(5) = value5
        data(6) = value6
        data(7) = value7
    i = ldevice
        Pid = IowKitGetProductId(iowHandles(ldevice - 1))
        If Pid = IOWKIT_PID_IOW24 Then
          ' First byte is controlling standard LED
         ' data(1) = Value
          ' Write to IOW 24
          nWritten = IowKitWrite(iowHandles(ldevice - 1), IOW_PIPE_IO_PINS, data(0), 3)
        Else
            If Pid = IOWKIT_PID_IOW40 Then
              ' Fourth byte is controlling standard LEDs
             ' data(4) = Value
              ' Write to IOW 40
              nWritten = IowKitWrite(iowHandles(ldevice - 1), IOW_PIPE_IO_PINS, data(0), 5)
            Else
                If Pid = IOWKIT_PID_IOW56 Then
                  ' Seventh byte is controlling standard LEDs
                 ' data(7) = Value
                  ' Write to IOW 56
                  nWritten = IowKitWrite(iowHandles(ldevice - 1), IOW_PIPE_IO_PINS, data(0), 8)
                End If
            End If
        End If
    
End Sub
Public Sub WriteBanks(ldevice As Integer, hwtype As Integer)
Dim tmpbuffer(1 To 7) As String
Dim x As Integer
'0 = iowarrior
'1 = mala
'2 = ledwiz hack
If hwtype = 0 Then
    'banks and digits are in the proper order
    For x = 1 To 7
        tmpval = ""
        For y = (((x - 1) * 8) + 1) To (((x - 1) * 8) + 1) + 7
            tmpval = tmpval + Trim(Str(iowBuffer(ldevice, y)))
        Next y
        tmpbuffer(x) = tmpval
    Next x
    data(1) = BinToDec(tmpbuffer(1))
    data(2) = BinToDec(tmpbuffer(2))
    data(3) = BinToDec(tmpbuffer(3))
    data(4) = BinToDec(tmpbuffer(4))
    data(5) = BinToDec(tmpbuffer(5))
    data(6) = BinToDec(tmpbuffer(6))
    data(7) = BinToDec(tmpbuffer(7))
Else
    'Digits in banks are reversed for MaLa Hardware
    If hwtype = 1 Then
       
        For x = 1 To 7
            tmpval = ""
          
            For y = (((x - 1) * 8) + 1) + 7 To (((x - 1) * 8) + 1) Step -1
                tmpval = tmpval + Trim(Str(iowBuffer(ldevice, y)))
            Next y
            tmpbuffer(x) = tmpval
        Next x
            data(1) = BinToDec(tmpbuffer(4))  'First 4 banks are also sent in reverse order for MaLa H/W
            data(2) = BinToDec(tmpbuffer(3))
            data(3) = BinToDec(tmpbuffer(2))
            data(4) = BinToDec(tmpbuffer(1))
            data(5) = BinToDec(tmpbuffer(5)) 'last 3 banks is superfluous for MaLa H/W
            data(6) = BinToDec(tmpbuffer(6))
            data(7) = BinToDec(tmpbuffer(7))

    Else
        'Digits in banks are reversed for LedWiz Hack
        For x = 1 To 7
            tmpval = ""
            For y = (((x - 1) * 8) + 1) + 7 To (((x - 1) * 8) + 1) Step -1
                tmpval = tmpval + Trim(Str(iowBuffer(ldevice, y)))
            Next y
            tmpbuffer(x) = tmpval
        Next x
        data(1) = BinToDec(tmpbuffer(1)) 'Banks sent in normal order
        data(2) = BinToDec(tmpbuffer(2))
        data(3) = BinToDec(tmpbuffer(3))
        data(4) = BinToDec(tmpbuffer(4))
        data(5) = BinToDec(tmpbuffer(5)) 'Last three banks is superfluous for ledwiz hack
        data(6) = BinToDec(tmpbuffer(6))
        data(7) = BinToDec(tmpbuffer(7))

    End If
End If

WriteLEDs ldevice, data(1), data(2), data(3), data(4), data(5), data(6), data(7)

End Sub


Public Sub KillIow()
Dim i As Integer
For i = 0 To numIows - 1
IowKitCloseDevice (iowHandles(i))
iowBufferAllOff (i)
Next i

End Sub

Public Sub ReadIOW(ldevice As Integer, dtype As Integer)

Dim x As Integer, y As Integer

Dim res As Long
Dim N As Long
Dim Pid As Long
Dim tmpstr As String

    ' Perform a read
Pid = IowKitGetProductId(iowHandles(ldevice - 1))
If Pid = IOWKIT_PID_IOW24 Then
      N = 3
Else
    If Pid = IOWKIT_PID_IOW40 Then
          N = 5
    Else
        If Pid = IOWKIT_PID_IOW56 Then
              N = 8
        End If
    End If
End If

    
    res = IowKitRead(iowHandles(ldevice - 1), 0, data(0), N)




'0 = iowarrior
'1 = mala
'2 = ledwiz hack
If hwtype = 0 Then
    'banks and digits are in the proper order
    For x = 1 To 7
        tmpstr = DecToBin(data(x))
        For y = (((x - 1) * 8) + 1) To (((x - 1) * 8) + 1) + 7
                iowBuffer(ldevice, y) = Mid(tmpstr, y, 1)
        Next y
    Next x
Else
    'both banks and digits are reversed
    If hwtype = 1 Then
        For x = 7 To 1 Step -1
            
            tmpstr = DecToBin(data(x))
            For y = (((x - 1) * 8) + 1) + 7 To (((x - 1) * 8) + 1) Step -1
                iowBuffer(ldevice, y) = Mid(tmpstr, y, 1)
            Next y
            
        Next x
    Else
        'banks are the same, digits in banks are reversed
        For x = 1 To 7
            tmpstr = DecToBin(data(x))
            For y = (((x - 1) * 8) + 1) + 7 To (((x - 1) * 8) + 1) Step -1
                iowBuffer(ldevice, y) = Mid(tmpstr, y, 1)
            Next y
            
        Next x
    End If
End If


End Sub
